<!DOCTYPE html>
<html>
	<head>
 

		<script src="gallery/jquery-1.5.min.js" type="text/javascript"></script>
		<script src="gallery/jquery.carouFredSel-5.1.0.js" type="text/javascript"></script>
		<script type="text/javascript">
			$(function() {
				$('#wrapper').hover(
					function() {
						$('#carousel').trigger( 'pause' );
						$('#thumbnails').parent().animate({
							top: 280
						});
					}, function() {
						
						$('#carousel').trigger( 'play' );
						$('#thumbnails').parent().animate({
							top: 375
						});
					}
				);

				$('#carousel').carouFredSel({
					scroll: {
						fx: 'crossfade'
					},
					auto: {
						onBefore: function( oldI, newI ) {
							$('#thumbnails').trigger( 'slideTo', [ '#thumbnails img[alt='+ newI.attr( 'alt' ) +']', -2 ] );
						}
					}
				});

				$('#thumbnails').carouFredSel({
					auto: false,
					items: {
						start: -2
					}
				});

				$('#thumbnails img').click(function() {
					$('#thumbnails').trigger( 'slideTo', [ this, -2 ] );
					$('#carousel').trigger( 'slideTo', [ '#carousel img[alt='+ $(this).attr( 'alt' ) +']' ] );

				}).css( 'cursor', 'pointer' );
			});
		</script>
		<style type="text/css">
			html, body {
				height: 100%;
				padding: 0;
				margin: 0;
			}
			body {
				min-height: 600px;
				min-width: 990px;
			}
			body * {
				font-family: Arial, Geneva, SunSans-Regular, sans-serif;
				font-size: 14px;
				color: #333;
				line-height: 22px;
			}

			#wrapper {
				width:800px;
				height: 400px;
				margin: 250px 0 0 -400px;
				overflow: hidden;
				position: absolute;
				left: 50%;
				top: 50%;
				
				box-shadow: 0 20px 50px #333;
			}
			#carousel {
				width:800px;
				height: 400px;
				overflow: hidden;
				position: absolute;
				top: 0;
				left: 0;
			}
			#carousel img {
				display: block;
				float: left;
			}
			#thumbnails {
				width:800px;
				height: 120px;
				overflow: hidden;
				position: absolute;
				top: 375px;
				left: 0;
				margin-left:40px;
			}
			#thumbnails img {
				display: block;
				float: left;
				margin: 10px;
				width: 100px;
				height: 100px;
				
				box-shadow: 0 0 10px #000;
			}
			#thumbnails img:hover {
				width: 110px;
				height: 110px;
				margin: 5px;
			}
		</style>
	</head>
	<body>
		<div id="wrapper">
			<div id="carousel">

				<img src="gallery/img/2.jpg" alt="c2" width="800" height="400" />
				<img src="gallery/img/3.jpg" alt="c3" width="800" height="400" />
				<img src="gallery/img/4.jpg" alt="c4" width="800" height="400" />
				<img src="gallery/img/5.jpg" alt="c5" width="800" height="400" />
				<img src="gallery/img/6.jpg" alt="c6" width="800" height="400" />
				<img src="gallery/img/7.jpg" alt="c7" width="800" height="400" />
				<img src="gallery/img/8.jpg" alt="c8" width="800" height="400" />
				<img src="gallery/img/9.jpg" alt="c9" width="800" height="400" />
 
			</div>
			<div id="thumbnails">

				<img src="gallery/img/2.jpg" alt="c2" width="100" height="100" />
				<img src="gallery/img/3.jpg" alt="c3" width="100" height="100" />
				<img src="gallery/img/4.jpg" alt="c4" width="100" height="100" />
				<img src="gallery/img/5.jpg" alt="c5" width="100" height="100" />
				<img src="gallery/img/6.jpg" alt="c6" width="100" height="100" />
				<img src="gallery/img/7.jpg" alt="c7" width="100" height="100" />
				<img src="gallery/img/8.jpg" alt="c8" width="100" height="100" />
				<img src="gallery/img/9.jpg" alt="c9" width="100" height="100" />
 
			</div>
		</div>
	</body>
</html>